<?php
/**
* @version      1.0.3
* @author       Paygine
* @package      Jshopping Paygine
* @copyright    Copyright (C) 2024 paygine.ru. All rights reserved.
* @license      GNU/GPL
*/

defined('_JEXEC') or die();

class com_paygineInstallerScript{
    private $com_jshopping_pm_path = JPATH_SITE . '/components/com_jshopping/payments';
    private $com_paygine_pm_path = JPATH_SITE . '/components/com_jshopping/payments/pm_paygine';
    private $com_paygine_path = JPATH_ADMINISTRATOR . '/components/com_paygine';

    public function install($parent){

        JFactory::getLanguage()->load('com_paygine');
        
        if(!file_exists($this->com_jshopping_pm_path)){
            echo '<p>' . JText::_('JSHOP_CFG_PAYGINE_JSH_NO_INSTALLED') . '</p>';
            return false;
        }
        if(!file_exists($this->com_paygine_pm_path)){
            if(!@mkdir($this->com_paygine_pm_path, 0755)){
                echo '<p>' . JText::_('JSHOP_CFG_PAYGINE_CREATE_DIR_ERROR') . " " . $this->com_paygine_pm_path . '</p>';
                return false;
            }
        }
        $filenames = ['adminparamsform.php', 'paymentform.php', 'pm_paygine.php'];
        $errors = '';
        foreach($filenames as $filename){
            if(!@copy($this->com_paygine_path . '/' . $filename, $this->com_paygine_pm_path . '/' . $filename))
                $errors .= JText::_('JSHOP_CFG_PAYGINE_COPY_ERROR') . " " . $filename . "\n";
        }
        if($errors){
            echo '<p>' . $errors . '</p>';
            return false;
        }
        return true;
    }

    public function uninstall($parent){
        if(file_exists($this->com_paygine_pm_path)){
            $files = glob($this->com_paygine_pm_path . "/*.*");
            foreach($files as $file_path){
                if(file_exists($file_path)) unlink($file_path);
            }
            return rmdir($this->com_paygine_pm_path);
        }
        return true;
    }
}